<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';

$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);

$response = $kernel->handle(
    $request = Illuminate\Http\Request::create(),
    new Illuminate\Http\Response()
);

echo "Testing CSC Auth...\n";

// TEST 1: SIGNUP
echo "\n[TEST 1] Signup (CSC ID: csc_test_999)...\n";
$req = Illuminate\Http\Request::create('/api/user/csc/signup', 'POST', [
    'csc_id' => 'csc_test_999',
    'password' => 'plain_text_pass_123',
    'phone_number' => '9998887776',
    'state' => 'TestState'
]);
$req->headers->set('Accept', 'application/json');
$response = $kernel->handle($req);

echo "Status: " . $response->getStatusCode() . "\n";
echo "Content: " . $response->getContent() . "\n";

if ($response->getStatusCode() !== 200 && $response->getStatusCode() !== 422) {
   // 422 might happen if testing multiple times (unique constraint)
   // We will handle that.
}

// TEST 2: LOGIN
echo "\n[TEST 2] Login (Correct Credentials)...\n";
$req = Illuminate\Http\Request::create('/api/user/csc/login', 'POST', [
    'csc_id' => 'csc_test_999',
    'password' => 'plain_text_pass_123'
]);
$req->headers->set('Accept', 'application/json');
$response = $kernel->handle($req);

echo "Status: " . $response->getStatusCode() . "\n";
echo "Content: " . $response->getContent() . "\n";

// TEST 3: INVALID LOGIN
echo "\n[TEST 3] Login (Wrong Password)...\n";
$req = Illuminate\Http\Request::create('/api/user/csc/login', 'POST', [
    'csc_id' => 'csc_test_999',
    'password' => 'wrong_pass'
]);
$req->headers->set('Accept', 'application/json');
$response = $kernel->handle($req);

echo "Status: " . $response->getStatusCode() . "\n";
echo "Content: " . $response->getContent() . "\n";
