# API Documentation - All Digital Seva

Base URL: `https://api.alldigtalseva.com`

---

## Table of Contents

1. [Admin APIs](#admin-apis)
2. [User APIs](#user-apis)
3. [Wallet APIs](#wallet-apis)
4. [UPI Management APIs](#upi-management-apis)

---

## Admin APIs

### Admin Login

Authenticate admin user and receive an access token.

**Endpoint:** `POST /api/admin/login`

**Request Headers:**
```
Content-Type: application/json
```

**Request Body:**
```json
{
    "username": "admin",
    "password": "admin123"
}
```

**Success Response (200):**
```json
{
    "success": true,
    "message": "Login successful",
    "data": {
        "id": 1,
        "username": "admin",
        "email": "admin@alldigtalseva.com",
        "token": "1|WYfQNViWRX9VhioBa9KJPJl8VlrrxoIsgHRDN1bj"
    }
}
```

**Error Response (401):**
```json
{
    "success": false,
    "message": "Invalid credentials"
}
```

**Error Response (422):**
```json
{
    "success": false,
    "message": "Validation error",
    "errors": {
        "username": ["The username field is required."],
        "password": ["The password field is required."]
    }
}
```

**cURL Example:**
```bash
curl -X POST https://api.alldigtalseva.com/api/admin/login \
  -H "Content-Type: application/json" \
  -d '{"username":"admin","password":"admin123"}'
```

**Note:** Password is stored and checked in plain text (not encrypted).

---

## User APIs

### User Signup

Register a new user and receive OTP via SMS.

**Endpoint:** `POST /api/user/signup`

**Request Headers:**
```
Content-Type: application/json
```

**Request Body:**
```json
{
    "email": "user@example.com",
    "phone_number": "1234567890",
    "user_type": "user"
}
```

**Parameters:**
- `email` (required, string, email): User's email address (must be unique)
- `phone_number` (required, string): User's phone number (must be unique)
- `user_type` (optional, enum): Type of user - `"user"` or `"distributor"` (default: `"user"`)

**Success Response (200):**
```json
{
    "success": true,
    "message": "OTP sent successfully to your phone number",
    "data": {
        "user_id": 1,
        "email": "user@example.com",
        "phone_number": "1234567890"
    }
}
```

**Error Response (422):**
```json
{
    "success": false,
    "message": "Validation error",
    "errors": {
        "email": ["The email has already been taken."],
        "phone_number": ["The phone number has already been taken."]
    }
}
```

**Error Response (409):**
```json
{
    "success": false,
    "message": "User already exists and is verified"
}
```

**cURL Example:**
```bash
curl -X POST https://api.alldigtalseva.com/api/user/signup \
  -H "Content-Type: application/json" \
  -d '{
    "email": "user@example.com",
    "phone_number": "1234567890",
    "user_type": "user"
  }'
```

**Notes:**
- OTP is sent via SMS to the provided phone number
- Phone number will be automatically formatted with country code 91 (India) if not provided
- OTP is valid for 10 minutes
- If user already exists but is not verified, a new OTP will be sent
- SMS is sent using WebTextSolution API with sender ID "FARMID"

---

### Verify OTP

Verify the OTP received via SMS to complete user signup.

**Endpoint:** `POST /api/user/verify-otp`

**Request Headers:**
```
Content-Type: application/json
```

**Request Body:**
```json
{
    "email": "user@example.com",
    "otp": "123456"
}
```

**Parameters:**
- `email` (required, string, email): User's email address
- `otp` (required, string, 6 digits): OTP received via SMS

**Success Response (200):**
```json
{
    "success": true,
    "message": "Signup completed successfully",
    "data": {
        "id": 1,
        "email": "user@example.com",
        "phone_number": "1234567890",
        "user_type": "user",
        "wallet_balance": "0.00",
        "is_verified": true
    }
}
```

**Error Response (401):**
```json
{
    "success": false,
    "message": "Invalid OTP"
}
```

**Error Response (401):**
```json
{
    "success": false,
    "message": "OTP has expired. Please request a new one."
}
```

**Error Response (400):**
```json
{
    "success": false,
    "message": "User already verified"
}
```

**Error Response (404):**
```json
{
    "success": false,
    "message": "User not found"
}
```

**Error Response (422):**
```json
{
    "success": false,
    "message": "Validation error",
    "errors": {
        "email": ["The email field is required."],
        "otp": ["The otp field is required."]
    }
}
```

**cURL Example:**
```bash
curl -X POST https://api.alldigtalseva.com/api/user/verify-otp \
  -H "Content-Type: application/json" \
  -d '{
    "email": "user@example.com",
    "otp": "123456"
  }'
```

**Notes:**
- OTP must be exactly 6 digits
- OTP expires after 10 minutes
- Once verified, user cannot verify again with the same OTP

---

### Resend OTP

Request a new OTP if the previous one expired or was not received.

**Endpoint:** `POST /api/user/resend-otp`

**Request Headers:**
```
Content-Type: application/json
```

**Request Body:**
```json
{
    "email": "user@example.com"
}
```

**Parameters:**
- `email` (required, string, email): User's email address

**Success Response (200):**
```json
{
    "success": true,
    "message": "OTP resent successfully to your phone number"
}
```

**Error Response (400):**
```json
{
    "success": false,
    "message": "User already verified"
}
```

**Error Response (404):**
```json
{
    "success": false,
    "message": "User not found"
}
```

**Error Response (422):**
```json
{
    "success": false,
    "message": "Validation error",
    "errors": {
        "email": ["The email field is required."]
    }
}
```

**cURL Example:**
```bash
curl -X POST https://api.alldigtalseva.com/api/user/resend-otp \
  -H "Content-Type: application/json" \
  -d '{
    "email": "user@example.com"
  }'
```

**Notes:**
- New OTP will be generated and sent via SMS to the registered phone number
- Previous OTP will be invalidated
- New OTP is valid for 10 minutes
- SMS is sent using WebTextSolution API

---

## Wallet APIs

### Top Up Wallet

Add funds to user's wallet balance.

**Endpoint:** `POST /api/wallet/top-up`

**Request Headers:**
```
Content-Type: application/json
```

**Request Body:**
```json
{
    "user_id": 1,
    "amount": 100.50
}
```

**Parameters:**
- `user_id` (required, integer): ID of the user
- `amount` (required, numeric, min: 0.01): Amount to add to wallet

**Success Response (200):**
```json
{
    "success": true,
    "message": "Wallet topped up successfully",
    "data": {
        "user_id": 1,
        "amount_added": "100.50",
        "new_balance": "100.50"
    }
}
```

**Error Response (403):**
```json
{
    "success": false,
    "message": "User is not verified. Please complete signup first."
}
```

**Error Response (422):**
```json
{
    "success": false,
    "message": "Validation error",
    "errors": {
        "user_id": ["The user id field is required."],
        "amount": ["The amount must be at least 0.01."]
    }
}
```

**cURL Example:**
```bash
curl -X POST https://api.alldigtalseva.com/api/wallet/top-up \
  -H "Content-Type: application/json" \
  -d '{
    "user_id": 1,
    "amount": 100.50
  }'
```

**Notes:**
- User must be verified before topping up wallet
- Amount must be a positive number (minimum 0.01)
- Balance is stored with 2 decimal places

---

### Get Wallet Balance

Retrieve the current wallet balance for a user.

**Endpoint:** `GET /api/wallet/balance`

**Request Headers:**
```
Content-Type: application/json
```

**Query Parameters:**
- `user_id` (required, integer): ID of the user

**Success Response (200):**
```json
{
    "success": true,
    "data": {
        "user_id": 1,
        "wallet_balance": "100.50"
    }
}
```

**Error Response (422):**
```json
{
    "success": false,
    "message": "Validation error",
    "errors": {
        "user_id": ["The user id field is required."]
    }
}
```

**cURL Example:**
```bash
curl -X GET "https://api.alldigtalseva.com/api/wallet/balance?user_id=1" \
  -H "Content-Type: application/json"
```

---

## User Types

Users can be of two types:

1. **user** - Regular user (default)
2. **distributor** - Distributor user

User type is set during signup and cannot be changed later.

---

## Error Codes

| Status Code | Description |
|------------|-------------|
| 200 | Success |
| 400 | Bad Request - Invalid operation (e.g., user already verified) |
| 401 | Unauthorized - Invalid credentials or OTP |
| 403 | Forbidden - User not verified |
| 404 | Not Found - Resource not found |
| 409 | Conflict - Resource already exists |
| 422 | Validation Error - Invalid input data |

---

## Authentication

### Admin Authentication

Admin APIs require authentication via token received from the login endpoint. Include the token in the Authorization header:

```
Authorization: Bearer {token}
```

**Example:**
```bash
curl -X GET https://api.alldigtalseva.com/api/protected-endpoint \
  -H "Authorization: Bearer 1|WYfQNViWRX9VhioBa9KJPJl8VlrrxoIsgHRDN1bj"
```

---

## Rate Limiting

API requests are rate-limited to 60 requests per minute per IP address.

Rate limit headers are included in responses:
- `X-RateLimit-Limit`: Maximum number of requests allowed
- `X-RateLimit-Remaining`: Number of requests remaining

---

## Notes

1. **Password Storage**: Admin passwords are stored in plain text (not encrypted) as per requirements.

2. **OTP Expiry**: OTPs expire after 10 minutes. Request a new OTP if expired.

3. **SMS Verification**: Users must verify their phone number via OTP (sent via SMS) before they can use wallet features. OTPs are sent using WebTextSolution SMS API.

4. **Phone Number Format**: Phone numbers are automatically formatted with country code 91 (India) if not already included.

5. **Wallet Balance**: Wallet balance is stored as decimal with 2 decimal places.

6. **Phone Number**: Phone numbers must be unique across all users.

7. **Email**: Email addresses must be unique across all users.

---

## Support

For API support or issues, please contact: admin@alldigtalseva.com

---

**Last Updated:** December 4, 2025

