<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOffersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('offers', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description')->nullable();
            $table->string('image_url')->nullable();
            $table->enum('offer_type', ['service_discount', 'signup_bonus', 'referral_bonus', 'cashback', 'general'])->default('general');
            $table->decimal('discount_percentage', 5, 2)->nullable(); // e.g., 10.50 for 10.5%
            $table->decimal('discount_amount', 10, 2)->nullable(); // Fixed discount amount
            $table->decimal('cashback_amount', 10, 2)->nullable(); // Cashback amount
            $table->string('promo_code')->nullable()->unique(); // Optional promo code
            $table->date('valid_from');
            $table->date('valid_to');
            $table->string('link')->nullable(); // Optional link when offer is clicked
            $table->integer('order')->default(0); // For ordering offers
            $table->boolean('is_active')->default(true);
            $table->unsignedBigInteger('created_by')->nullable(); // Admin who created it
            $table->timestamps();
            
            $table->foreign('created_by')->references('id')->on('admins')->onDelete('set null');
            $table->index('is_active');
            $table->index('valid_from');
            $table->index('valid_to');
            $table->index('order');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('offers');
    }
}
