<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReferralEarningsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('referral_earnings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('referrer_id')->comment('User who earned the commission');
            $table->unsignedBigInteger('referred_id')->comment('User who generated the earning');
            $table->integer('level')->default(1)->comment('Referral level');
            $table->enum('earning_type', ['signup', 'topup', 'transaction'])->default('topup')->comment('Type of earning');
            $table->unsignedBigInteger('source_id')->nullable()->comment('ID of source (e.g., top_up_request_id)');
            $table->string('source_type')->nullable()->comment('Type of source (e.g., TopUpRequest)');
            $table->decimal('amount', 10, 2)->comment('Original amount that generated commission');
            $table->decimal('commission_amount', 10, 2)->comment('Commission earned');
            $table->enum('status', ['pending', 'credited', 'cancelled'])->default('pending');
            $table->timestamp('credited_at')->nullable();
            $table->timestamps();
            
            $table->foreign('referrer_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('referred_id')->references('id')->on('users')->onDelete('cascade');
            $table->index('referrer_id');
            $table->index('referred_id');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('referral_earnings');
    }
}
