<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Slider;
use Illuminate\Http\Request;

class SliderController extends Controller
{
    /**
     * Get All Active Sliders for Landing Page
     * Public endpoint - no authentication required
     */
    public function index()
    {
        $sliders = Slider::where('is_active', true)
            ->orderBy('order', 'asc')
            ->orderBy('created_at', 'desc')
            ->get(['id', 'title', 'description', 'image_url', 'link', 'order']);

        return response()->json([
            'success' => true,
            'data' => $sliders
        ], 200);
    }

    /**
     * Get Single Slider (Public)
     */
    public function show($id)
    {
        $slider = Slider::where('is_active', true)
            ->find($id, ['id', 'title', 'description', 'image_url', 'link', 'order']);

        if (!$slider) {
            return response()->json([
                'success' => false,
                'message' => 'Slider not found or inactive'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'data' => $slider
        ], 200);
    }
}
